/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.serialization.jankson;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import corgitaco.corgilib.serialization.codec.CommentsTracker;
import corgitaco.corgilib.serialization.codec.CommentsTrackerMapLike;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonArray;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonNull;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonObject;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public record JanksonJsonOps(boolean compressed) implements DynamicOps<JsonElement>
{
    public static final JanksonJsonOps INSTANCE = new JanksonJsonOps(false);
    public static final JanksonJsonOps COMPRESSED = new JanksonJsonOps(true);

    public JsonElement empty() {
        return JsonNull.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
        if (input instanceof JsonObject) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof JsonArray) {
            return (U)this.convertList(outOps, input);
        }
        if (input instanceof JsonNull) {
            return (U)outOps.empty();
        }
        JsonPrimitive primitive = (JsonPrimitive)input;
        Object value = primitive.getValue();
        if (value instanceof String) {
            return (U)outOps.createString(primitive.asString());
        }
        if (value instanceof Boolean) {
            return (U)outOps.createBoolean(primitive.asBoolean(false));
        }
        BigDecimal bigDecimal = primitive.asBigDecimal(new BigDecimal(primitive.asString()));
        try {
            long l = bigDecimal.longValueExact();
            if ((long)((byte)l) == l) {
                return (U)outOps.createByte((byte)l);
            }
            if ((long)((short)l) == l) {
                return (U)outOps.createShort((short)l);
            }
            if ((long)((int)l) == l) {
                return (U)outOps.createInt((int)l);
            }
            return (U)outOps.createLong(l);
        }
        catch (ArithmeticException e) {
            double d = bigDecimal.doubleValue();
            if ((double)((float)d) == d) {
                return (U)outOps.createFloat((float)d);
            }
            return (U)outOps.createDouble(d);
        }
    }

    public DataResult<Number> getNumberValue(JsonElement input) {
        JsonPrimitive primitive;
        if (input instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)input;
            Object value = jsonPrimitive.getValue();
            if (value instanceof Number) {
                Number number = (Number)value;
                return DataResult.success((Object)number);
            }
            if (value instanceof Boolean) {
                Boolean bl = (Boolean)value;
                return DataResult.success((Object)(bl != false ? 1 : 0));
            }
            if (this.compressed && value instanceof String) {
                String s = (String)value;
                try {
                    return DataResult.success((Object)Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return DataResult.error(() -> "Not a number: " + String.valueOf(e) + " " + String.valueOf(input));
                }
            }
        }
        if (input instanceof JsonPrimitive && (primitive = (JsonPrimitive)input).getValue() instanceof Boolean) {
            return DataResult.success((Object)((Boolean)primitive.getValue() != false ? 1 : 0));
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    public JsonElement createNumeric(Number i) {
        return new JsonPrimitive(i);
    }

    public DataResult<Boolean> getBooleanValue(JsonElement input) {
        if (input instanceof JsonPrimitive) {
            Object value = ((JsonPrimitive)input).getValue();
            if (value instanceof Boolean) {
                Boolean bl = (Boolean)value;
                return DataResult.success((Object)bl);
            }
            if (value instanceof Number) {
                Number num = (Number)value;
                return DataResult.success((Object)(num.byteValue() != 0 ? 1 : 0));
            }
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public JsonElement createBoolean(boolean value) {
        return new JsonPrimitive(value);
    }

    public DataResult<String> getStringValue(JsonElement input) {
        JsonPrimitive primitive;
        if (input instanceof JsonPrimitive && ((primitive = (JsonPrimitive)input).getValue() instanceof String || primitive.getValue() instanceof Number && this.compressed)) {
            return DataResult.success((Object)primitive.asString());
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public JsonElement createString(String value) {
        return new JsonPrimitive(value);
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, JsonElement value) {
        if (!(list instanceof JsonArray) && list != this.empty()) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
        }
        JsonArray result = new JsonArray();
        if (list != this.empty()) {
            result.addAll((Collection)((Object)list));
        }
        result.add(value);
        return DataResult.success((Object)result);
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, List<JsonElement> values) {
        if (!(list instanceof JsonArray) && list != this.empty()) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
        }
        JsonArray result = new JsonArray();
        if (list != this.empty()) {
            result.addAll((Collection)((Object)list));
        }
        result.addAll((Collection<? extends JsonElement>)values);
        return DataResult.success((Object)result);
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, JsonElement key, JsonElement value) {
        JsonPrimitive primitive;
        if (!(map instanceof JsonObject) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof JsonPrimitive) || !((primitive = (JsonPrimitive)key).getValue() instanceof String) && !this.compressed) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        }
        JsonObject output = new JsonObject();
        if (map != this.empty()) {
            output.putAll((JsonObject)map);
        }
        output.put(((JsonPrimitive)key).asString(), value);
        return DataResult.success((Object)output);
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, MapLike<JsonElement> values) {
        if (!(map instanceof JsonObject) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        JsonObject output = new JsonObject();
        if (map != this.empty()) {
            output.putAll((JsonObject)map);
        }
        ArrayList missed = Lists.newArrayList();
        values.entries().forEach(entry -> {
            JsonPrimitive primitive;
            JsonElement key = (JsonElement)entry.getFirst();
            if (!(key instanceof JsonPrimitive) || !((primitive = (JsonPrimitive)key).getValue() instanceof String) && !this.compressed) {
                missed.add(key);
                return;
            }
            output.put(((JsonPrimitive)key).asString(), (JsonElement)entry.getSecond());
        });
        if (!missed.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf(missed), (Object)output);
        }
        return DataResult.success((Object)output);
    }

    public DataResult<Stream<Pair<JsonElement, JsonElement>>> getMapValues(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
        }
        return DataResult.success(((JsonObject)input).entrySet().stream().map(entry -> Pair.of((Object)new JsonPrimitive(entry.getKey()), entry.getValue() instanceof JsonNull ? null : (JsonElement)entry.getValue())));
    }

    public DataResult<Consumer<BiConsumer<JsonElement, JsonElement>>> getMapEntries(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
        }
        return DataResult.success(c -> {
            for (Map.Entry<String, JsonElement> entry : ((JsonObject)input).entrySet()) {
                c.accept(this.createString(entry.getKey()), entry.getValue() instanceof JsonNull ? null : entry.getValue());
            }
        });
    }

    public DataResult<MapLike<JsonElement>> getMap(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
        }
        final JsonObject object = (JsonObject)input;
        return DataResult.success((Object)new CommentsTrackerMapLike<JsonElement>(this){

            public @Nullable JsonElement get(JsonElement key) {
                JsonElement element = object.get(((JsonPrimitive)key).asString());
                if (element instanceof JsonNull) {
                    return null;
                }
                return element;
            }

            public @Nullable JsonElement get(String key) {
                JsonElement element = object.get(key);
                if (element instanceof JsonNull) {
                    return null;
                }
                return element;
            }

            public Stream<Pair<JsonElement, JsonElement>> entries() {
                return object.entrySet().stream().map(e -> Pair.of((Object)new JsonPrimitive(e.getKey()), (Object)((JsonElement)e.getValue())));
            }

            public String toString() {
                return "MapLike[" + String.valueOf(object) + "]";
            }

            @Override
            public void addComment(String key, String comment) {
                object.setComment(key, comment);
            }

            @Override
            public @Nullable String getComment(String key) {
                return object.getComment(key);
            }
        });
    }

    public JsonElement createMap(Stream<Pair<JsonElement, JsonElement>> map) {
        JsonObject result = new JsonObject();
        map.forEach(p -> result.put(((JsonPrimitive)p.getFirst()).asString(), (JsonElement)p.getSecond()));
        return result;
    }

    public DataResult<Stream<JsonElement>> getStream(JsonElement input) {
        if (input instanceof JsonArray) {
            return DataResult.success(((JsonArray)input).stream().map(e -> e instanceof JsonNull ? null : e));
        }
        return DataResult.error(() -> "Not a json array: " + String.valueOf(input));
    }

    public DataResult<Consumer<Consumer<JsonElement>>> getList(JsonElement input) {
        if (input instanceof JsonArray) {
            return DataResult.success(c -> {
                for (JsonElement element : (JsonArray)input) {
                    c.accept(element instanceof JsonNull ? null : element);
                }
            });
        }
        return DataResult.error(() -> "Not a json array: " + String.valueOf(input));
    }

    public JsonElement createList(Stream<JsonElement> input) {
        JsonArray result = new JsonArray();
        input.forEach(result::add);
        return result;
    }

    public JsonElement remove(JsonElement input, String key) {
        if (input instanceof JsonObject) {
            JsonObject result = new JsonObject();
            ((JsonObject)input).entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(entry -> result.put((String)entry.getKey(), (JsonElement)entry.getValue()));
            return result;
        }
        return input;
    }

    @Override
    public String toString() {
        return "Jankson JSON";
    }

    public ListBuilder<JsonElement> listBuilder() {
        return new ArrayBuilder();
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    public RecordBuilder<JsonElement> mapBuilder() {
        return new JsonRecordBuilder(this);
    }

    private static final class ArrayBuilder
    implements ListBuilder<JsonElement> {
        private DataResult<JsonArray> builder = DataResult.success((Object)new JsonArray(), (Lifecycle)Lifecycle.stable());

        private ArrayBuilder() {
        }

        public DynamicOps<JsonElement> ops() {
            return INSTANCE;
        }

        public ListBuilder<JsonElement> add(JsonElement value) {
            this.builder = this.builder.map(b -> {
                b.add(value);
                return b;
            });
            return this;
        }

        public ListBuilder<JsonElement> add(DataResult<JsonElement> value) {
            this.builder = this.builder.apply2stable((b, element) -> {
                b.add((JsonElement)element);
                return b;
            }, value);
            return this;
        }

        public ListBuilder<JsonElement> withErrorsFrom(DataResult<?> result) {
            this.builder = this.builder.flatMap(r -> result.map(v -> r));
            return this;
        }

        public ListBuilder<JsonElement> mapError(UnaryOperator<String> onError) {
            this.builder = this.builder.mapError(onError);
            return this;
        }

        public DataResult<JsonElement> build(JsonElement prefix) {
            DataResult result = this.builder.flatMap(b -> {
                if (!(prefix instanceof JsonArray) && prefix != this.ops().empty()) {
                    return DataResult.error(() -> "Cannot append a list to not a list: " + String.valueOf(prefix), (Object)prefix);
                }
                JsonArray array = new JsonArray();
                if (prefix != this.ops().empty()) {
                    array.addAll((JsonArray)prefix);
                }
                array.addAll((Collection<? extends JsonElement>)b);
                return DataResult.success((Object)array, (Lifecycle)Lifecycle.stable());
            });
            this.builder = DataResult.success((Object)new JsonArray(), (Lifecycle)Lifecycle.stable());
            return result;
        }
    }

    private class JsonRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<JsonElement, JsonObject>
    implements CommentsTracker {
        private final Map<String, String> comments = new HashMap<String, String>();

        protected JsonRecordBuilder(JanksonJsonOps janksonJsonOps) {
            super((DynamicOps)janksonJsonOps);
        }

        protected JsonObject initBuilder() {
            return new JsonObject();
        }

        protected JsonObject append(String key, JsonElement value, JsonObject builder) {
            builder.put(key, value);
            return builder;
        }

        protected DataResult<JsonElement> build(JsonObject builder, JsonElement prefix) {
            block7: {
                block6: {
                    if (prefix == null) break block6;
                    if (!(prefix instanceof JsonNull)) break block7;
                }
                this.comments.forEach(builder::setComment);
                return DataResult.success((Object)builder);
            }
            if (prefix instanceof JsonObject) {
                String key;
                JsonObject prefixObject = (JsonObject)prefix;
                JsonObject result = new JsonObject();
                for (Map.Entry<String, JsonElement> entry : prefixObject.entrySet()) {
                    key = entry.getKey();
                    result.put(key, entry.getValue());
                    if (!this.comments.containsKey(key)) continue;
                    result.setComment(key, this.comments.get(key));
                }
                for (Map.Entry<String, JsonElement> entry : builder.entrySet()) {
                    key = entry.getKey();
                    result.put(key, entry.getValue());
                    if (!this.comments.containsKey(key)) continue;
                    result.setComment(key, this.comments.get(key));
                }
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(prefix), (Object)prefix);
        }

        @Override
        public void addComment(String key, String comment) {
            this.comments.put(key, comment);
        }

        @Override
        public @Nullable String getComment(String key) {
            return ((JsonObject)this.builder.result().orElseThrow()).getComment(key);
        }
    }
}

